/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.tag.api;

import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_3494;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.quiltmc.qsl.tag.api.TagType;
import org.quiltmc.qsl.tag.impl.TagRegistryImpl;
import org.quiltmc.qsl.tag.impl.client.ClientTagRegistryManager;

public final class TagRegistry {
    private TagRegistry() {
        throw new UnsupportedOperationException("TagRegistry only contains static definitions.");
    }

    public static <T> Stream<TagEntry<T>> stream(class_5321<? extends class_2378<T>> registry) {
        return TagRegistry.stream(registry, TagType.NORMAL);
    }

    public static <T> Stream<TagEntry<T>> stream(class_5321<? extends class_2378<T>> registry, TagType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TagType.NORMAL -> TagRegistryImpl.streamTags(registry);
            case TagType.CLIENT_FALLBACK -> TagRegistryImpl.streamTagsWithFallback(registry);
            case TagType.CLIENT_ONLY -> ClientTagRegistryManager.get(registry).streamClientTags();
        };
    }

    public static <T> class_3494<class_6880<T>> getTag(class_6862<T> key) {
        return TagRegistryImpl.getTag(key);
    }

    public record TagEntry<T>(class_6862<T> key, class_3494<class_6880<T>> tag) {
    }
}

